#include "PIC24F_periph_features.h"
#include "stdio.h"
#include "HardwareProfile.h"
extern void LcdPrintString (BYTE *);
extern volatile unsigned int  OneMs;
extern char LCDText[];
void  delay_usec(int);
extern int areg;  
extern int breg; 
unsigned long spi_buf_data1;
unsigned long get_three;
extern char LcdBuf[];
void InitADE7758(void);
void OpenSPI3(void);
int Get_Two_Reg( unsigned int);
unsigned int d = 0x01;
int Get_Ade_Reg( unsigned int);
void Put_Two_Reg( unsigned int ,unsigned int  );
void Put_Three_Reg( unsigned int ,unsigned long  );
unsigned long Get_Three_Reg( unsigned int  );
int I;
int Previous_Event=0;
int Cur_Event=0;
int sample =0;
int Vrms_Sample[10];
void ADE7758IntHandler(void);
volatile int areg_temp;
volatile int breg_temp;
volatile int creg_temp;
int int_event=0;
unsigned long Long_Int_A=0;
unsigned long Long_Int_B=0;
unsigned long Long_Int_C=0;
unsigned int Int_A=0;
unsigned int Int_B=0;
unsigned int Int_C=0;
int 	Vrms_Average = 0;



static inline __attribute__((__always_inline__)) void WaitForByte( void )
    {
        while ((SPI3STATbits.SPITBF == 1) || (SPI3STATbits.SPIRBF == 0));
    }





/***************************************************************************************

Cut and paste into c file that has loop 

extern int Get_Ade_Reg( unsigned int);
extern void InitADE7758(void);
extern void OpenSPI3(void);





cut and paste in main
InitADE7758();
OpenSPI3();


***************************************************************************************/







/******************************************************************************
Function           : char DataRdySPI3(void)

Description        : This function determines if the SPI buffer contains
                     any data to be read.
 
Arguments          : None
 
Returns            : If 1 is returned, it indicates that the data has been
                     received in the receive buffer and is to be read.
                     If 0 is returned, it indicates that the receive is not 
                     complete and the receive buffer is empty.
 
Remarks            : This function returns the status of SPI receive buffer.
                     This indicates if the SPI receive buffer contains any new 
                     data that is yet to be read as indicated by the 
                     SPIxSTAT<SPIRBF> bit. This bit is cleared by hardware 
                     when the data is read from the buffer.
*******************************************************************************/
char DataRdySPI3(void)
{
    return SPI3STATbits.SPIRBF; /* return RBF bit status */
}






/*********************************************************************************
Function           : void OpenSPI3(unsigned int config1,unsigned int config2,
                                    unsigned int config3)

Include            : spi.h
 
Description        : This function configures the SPI module
 
Arguments          : config1 - This contains the parameters to be configured in the
                     SPIxCON1 register as defined below					 				
					 
				 SCK Pin Control bit
					*	DISABLE_SCK_PIN
					*	ENABLE_SCK_PIN 
				 SDO Pin Control bit					
					*	DISABLE_SDO_PIN					
					*	ENABLE_SDO_PIN					
				 Word/Byte Communication mode					
					*	SPI_MODE16_ON					
					*	SPI_MODE8_ON					
				 SPI Data Input Sample phase					
					*	SPI_SMP_ON					
					*	SPI_SMP_OFF					
				 SPI Clock Edge Select					
					*	SPI_CKE_ON					
					*	SPI_CKE_OFF					
				 SPI slave select enable					
					*	SLAVE_ENABLE_ON					
					*	SLAVE_ENABLE_OFF					
				 SPI Clock polarity select					
					*	CLK_POL_ACTIVE_LOW					
					*	CLK_POL_ACTIVE_HIGH					
				 SPI Mode Select bit					
					*	MASTER_ENABLE_ON					
					*	MASTER_ENABLE_OFF					
				 Secondary Prescale select					
					*	SEC_PRESCAL_1_1					
					*	SEC_PRESCAL_2_1					
					*	SEC_PRESCAL_3_1					
					*	SEC_PRESCAL_4_1					
					*	SEC_PRESCAL_5_1					
					*	SEC_PRESCAL_6_1					
					*	SEC_PRESCAL_7_1					
					*	SEC_PRESCAL_8_1					
				 Primary Prescale select					
					*	PRI_PRESCAL_1_1					
					*	PRI_PRESCAL_4_1					
					*	PRI_PRESCAL_16_1					
					*	PRI_PRESCAL_64_1					
					 
		 config2 - This contains the parameters to be configured in the
                     SPIxCON2 register as defined below
				 Frame SPI support Enable/Disable					
					*	FRAME_ENABLE_ON					
					*	FRAME_ENABLE_OFF					
				 Frame Sync Pulse direction control					
					*	FRAME_SYNC_INPUT					
					*	FRAME_SYNC_OUTPUT
				 Frame Sync Polarity bit  
					*	FRAME_SYNC_ACTIVE_HIGH
					*	FRAME_SYNC_ACTIVE_LOW
				 Frame Delay bit  
					*	SPI_FRM_PULSE_FIRST_CLK
					*	SPI_FRM_PULSE_PREV_CLK
				 Enhance Buffer Enable\Disable
					*	SPI_ENH_BUFF_ENABLE
					*	SPI_ENH_BUFF_DISABLE    
											
		 config3 - This contains the parameters to be configured in the					
		 SPIxSTAT register as defined below
		 
				 SPI Enable/Disable					
					*	SPI_ENABLE					
					*	SPI_DISABLE					
				 SPI Idle mode operation					
					*	SPI_IDLE_CON					
					*	SPI_IDLE_STOP					
				 Clear Receive Overflow Flag bit
					*	SPI_RX_OVFLOW					
					*	SPI_RX_OVFLOW_CLR
 
Returns            : None
 
Remarks            : This functions initializes the SPI module and sets the Idle mode
                     Operation. 
**************************************************************************************/

void OpenSPI3(void)
{
         					
     SPI3CON1 = 0x023e;    //  Fcy Primary prescaler 1:16, secondary prescaler 1:1, CPK=0, CKE=0, SMP=1
     SPI3CON2 = 0x0000;		// 1 mhz =0x023d for 8 mhz use 0x023b 4mhz 0x023e 2mhz 0x023a
     SPI3STAT = 0x8000;
     
}






/******************************************************************************************
Function           : void putsSPI3(unsigned int length,unsigned int *wrptr)

Description        : This function writes the data to be transmitted into the
                     Transmit Buffer (SPIxBUF) register.
 
Arguments          : length - This is the number of data words/bytes to be transmitted.
                     wrptr - This is the pointer to the string of data to be transmitted
 
Returns            : None
 
Remarks            : This function writes the specified length of data words/bytes to be
                     transmitted into the transmit buffer.Once the transmit buffer is full,
                     it waits until the data gets transmitted and then writes the next data
                     into the Transmit register.The control remains in this function if SPI
                     module is disabled while SPITBF bit is set.
********************************************************************************************/
void putsSPI3(unsigned int length, unsigned int *wrptr)
{
	int temp1;
    char *temp_ptr = (char *) wrptr;
    while (length)                   /* write byte/word until length is 0 */
    {
	    
	   // while(SPI3STATbits.SPITBF);
	  temp1 = *wrptr;
        SPI3BUF = *temp_ptr++;   /* initiate SPI bus cycle by byte write */
        
        while(SPI3STATbits.SPITBF);  /* wait until 'SPITBF' bit is cleared */
        length--;                    /* decrement length */
    }
}






/************************************************************************************
Function           : unsigned int ReadSPI3(void)

Description        : This function reads the content of the SPI Receive Buffer 
                     (SPIxBUF) register.

Precondition       : Before ReadSPI call SPI3_Rx_Buf_Full macro to check whether 
                     data is reaceived.                     
 
Arguments          : None
 
Returns            : This function returns the content of Receive Buffer 
                     (SPIxBUF) register.                  
 
Remarks            : This function returns the content of the Receive Buffer register.
                     If 16-bit communication is enabled, the data in the SPIxBUF
                     register is returned.
                     If 8-bit communication is enabled, then the lower byte of SPIxBUF
                     is returned.                   
**************************************************************************************/
unsigned int ReadSPI3()
{
	
   SPI3STATbits.SPIROV = 0;

    return (SPI3BUF & 0xff);   /* return byte read */
  
}






/********************************************************************************
Function           : void WriteSPI3(unsigned int data_out)

Description        : This function writes the data to be transmitted 
                     into the Transmit Buffer (SPIxBUF) register.
 
Arguments          : data_out - This is the data to be transmitted which 
                     will be stored in SPI buffer.
 
Returns            : None
 
Remarks            : This function writes the data (byte/word) to be transmitted
                     into the transmit buffer.
                     If 16-bit communication is enabled, the 16-bit value is 
                     written to the transmit buffer.
                     If 8-bit communication is enabled, then upper byte is masked
                     and then written to the transmit buffer.
**********************************************************************************/
void WriteSPI3(unsigned int data_out)
{
    if (SPI3CON1bits.MODE16)           /* word write */
        SPI3BUF = data_out;
    else
        SPI3BUF = data_out & 0xff;	  /*  byte write  */
}






void InitADE7758(void)
{
	
	// Inputs
	RPINR20bits.SDI1R = 15;			//SDI1 = RPI0
    //RPINR0bits.INT1R = 19; 			//assign interrupt 1 to RP19
	RPINR28bits.SDI3R = 21;	    // SDI goes to RP27

	// Outputs
	RPOR13bits.RP26R = 33; 	//RP26 = SCK1
	RPOR13bits.RP27R = 32;		//RP21 = SDO1

	// MISC LEADS
	TRISGbits.TRISG9=0;
	TRISGbits.TRISG7=0;
	TRISGbits.TRISG6=1;
	TRISB = 0x00;
	AD1PCFGL = 0xFFFF;
	ODCBbits.ODB2 = 1;  //0X0002;
	LATBbits.LATB2 = 1;  //RELEASE 7758 FROM reset	
	
}

int Get_Ade_Reg( unsigned int a )	

{
	
	IEC0bits.T2IE = 0;  //disable t2 interrupt
	unsigned int l=1;
	unsigned int ff= 0xff;

	
LATBbits.LATB3 =0; //select chip and leave it selected
	
	delay_usec(20);
//	spi_buf_data1 = ReadSPI3(); // get byte
	
//	a = a - 0x80;
	putsSPI3(l,&a); // issue a read command of reg 0b
	delay_usec(20);
			

	putsSPI3(l,&ff); // clock it out
	spi_buf_data1 = ReadSPI3(); // clear spi buffer	
	
	delay_usec(20);
	

	spi_buf_data1= ReadSPI3(); // get byte
	
		
		
//	sprintf(LcdBuf,"%X%s%X",spi_buf_data1,"   ",a);
		
//	LcdPrintString();



	delay_usec(20);
	LATBbits.LATB3 =1; //de-select chip 
	IEC0bits.T2IE = 1;  // enable t2 interrupt
	
	
	return(spi_buf_data1);

}	

// this routine will write data to register that require 24 bits

void Put_Two_Reg( unsigned int a,unsigned int b )	

{
	
	
LATBbits.LATB3 =0; //select chip and leave it selected
unsigned int Byte1 = 0;
unsigned int Byte2 = 0;
unsigned int Mask = 0xff;
	
	// a = register address b = data to write


	
	
	
 delay_usec(20);
  	Byte2 |= b&Mask;    //low byte
  	
  	b >>= 8;      		
    Byte1 |= b&Mask;    // Get high byte  
  	
  

	// Now wite to 7758
	
	
	a = a + 0x80;	// setting bit 8 indicates write to 7758 a = adress
	putsSPI3(1,&a); // issue write command  
	delay_usec(20);
	
	putsSPI3(1,&Byte1); // write MSB
	b >>= 8;
	delay_usec(20);
	putsSPI3(1,&Byte2); // write low byte
	
	delay_usec(20);

	
	delay_usec(20);
	delay_usec(20);
	LATBbits.LATB3 =1; //select chip and leave it selected
}

unsigned long Get_Three_Reg( unsigned int a )	

{
	IEC0bits.T2IE = 0;  //disable t2 interrupt
	LATBbits.LATB3 =0; //select chip and leave it selected
	long spi_buf = 0;
	// a= register address
	unsigned int l=1;
	unsigned int Mask= 0xff;
	unsigned int ff= 0xff;
	unsigned int temp1 =0;
	unsigned int temp2 =0;
	unsigned int temp3 =0;
	unsigned int temp_trash;

	

	delay_usec(120);
	delay_usec(120);
	
	temp_trash = ReadSPI3(); // clear spi buffer
	putsSPI3(l,&a); // issue a read command of reg a
	WaitForByte(); //bob 	while (SPI3STATbits.SPIRBF == 0);
	temp_trash = ReadSPI3(); // clear spi buffer

	putsSPI3(l,&ff); // clock it out
	WaitForByte(); //bob 	while (SPI3STATbits.SPIRBF == 0);
	temp1 = ReadSPI3(); // get byte one
	spi_buf |= temp1&Mask;
	spi_buf <<= 8;       // shift first 

	putsSPI3(l,&ff); // clock it out
	WaitForByte(); //bob 	while (SPI3STATbits.SPIRBF == 0);
	temp2 = ReadSPI3(); // get byte two
	spi_buf |=temp2&Mask;
	spi_buf <<= 8;       // shift first 

	putsSPI3(l,&ff); // clock it out
	WaitForByte(); //bob 	while (SPI3STATbits.SPIRBF == 0);
	temp3 = ReadSPI3(); // get byte three
	spi_buf |= temp3&Mask;

 	delay_usec(20);		
	delay_usec(20);		
	LATBbits.LATB3 =1; //de-select chip 
	delay_usec(20);	
	delay_usec(20);
	IEC0bits.T2IE = 1;  // enable t2 interrupt
	delay_usec(20);
	return(spi_buf);	
	
}

void Put_One_Reg( unsigned int a,unsigned int b)	

{
	
	// a = register address b = data to write

	LATBbits.LATB3 =0; //select chip and leave it selected// SELECT ENERGY CHIP
 		delay_usec(20);
	
  // Now write to 7758
	a = a + 0x80;	// setting bit 8 indicates write to 7758 a = adress
	putsSPI3(1,&a); // issue write command  
	delay_usec(20);
	
	putsSPI3(1,&b); // write byte
	delay_usec(20);
	
	LATBbits.LATB3 =1; //de-select chip 

		delay_usec(20);	
	

	

}

int Get_Two_Reg( unsigned int a )	

{
	
	unsigned int l=1;
	unsigned int Mask= 0xff;
	unsigned int ff= 0xff;
	unsigned int temp1 =0;
	unsigned int temp2 =0;
	unsigned int temp_trash;
	
	
	IEC0bits.T2IE = 0; // disable t2 interrupt
	LATBbits.LATB3 =0; //select chip and leave it selected
	delay_usec(10);	
	delay_usec(10);	
	spi_buf_data1 = 0;
	delay_usec(1);

	temp_trash = ReadSPI3();

	putsSPI3(l,&a); // issue a read command of reg a
	WaitForByte(); //bob 	while (SPI3STATbits.SPIRBF == 0);
    temp_trash = ReadSPI3(); // clear trash from spi buffer	

	putsSPI3(l,&ff); // clock it out
	WaitForByte(); //bob 	while (SPI3STATbits.SPIRBF == 0);
	temp1 = ReadSPI3(); // get byte one
	spi_buf_data1 |= temp1&Mask;
	spi_buf_data1 <<= 8;       // shift first 
	delay_usec(5);

	putsSPI3(l,&ff); // clock it out
	WaitForByte(); // bob while (SPI3STATbits.SPIRBF == 0);
	temp2 = ReadSPI3(); // get byte two
	spi_buf_data1 |=temp2&Mask;
	delay_usec(20);
	LATBbits.LATB3 =1; //deselect chip
	delay_usec(10);	
	IEC0bits.T2IE = 1; //  enable t2 interrupt
	delay_usec(10);	
	return(spi_buf_data1);	
	
}


void Put_Three_Reg( unsigned int a,unsigned long b )	

{
	
// bob  while(SPI1STATbits.SPITBF);	



LATBbits.LATB3 =0; //select chip and leave it selected
unsigned int Byte1 = 0;
unsigned int Byte2 = 0;
unsigned int Byte3 = 0;
unsigned int Mask = 0xff;
	
	// a = register address b = data to write

	delay_usec(20);
  	Byte3 |= b&Mask;    //low byte
  	
  	b >>= 8;      		
    Byte2 |= b&Mask;    // Get middle byte  
  	
  	b >>= 8;      		
    Byte1 |= b&Mask;    // Get high byte  

	// Now write to 7758
	
	
	a = a + 0x80;	// setting bit 8 indicates write to 7758 a = adress
	putsSPI3(1,&a); // issue write command  
	delay_usec(20);
	
	putsSPI3(1,&Byte1); // write MSB

	delay_usec(20);
	putsSPI3(1,&Byte2); // write middle byte
	
	delay_usec(20);
	putsSPI3(1,&Byte3); // write low byte
	
	delay_usec(20);

	
	delay_usec(20);
	delay_usec(20);
	LATBbits.LATB3 =1; //deselect chip
}












void ADE7758_Init()
{
      /* disable the external interrupt */
      ADE7758_INT_IE = 0;
      /* configure IO pin as input and External Interrupt pin*/
      /* set the I/O high since we do not have pull-ups */
     // ADE7758_INT_IO   = 1;
      ADE7758_INT_TRIS = 1;
      ADE7758_INT_EDGE = 1;   /* falling edge triggered */
      /* clear and enable the interrupt */
	 Put_Three_Reg(0x18,0x000001);  // start interrupt for watt reg half full 
     get_three = Get_Three_Reg(0x1a); //allow interrupt
      ADE7758_INT_IF = 0;
      ADE7758_INT_IE = 1;
}

		//Put_Three_Reg(0x18,0x000001);  // start interrupt for watt reg half full 
		//get_three = Get_Three_Reg(0x1a);	
 void __attribute__((interrupt, auto_psv)) _INT3Interrupt(void)
 {
	 	
     // clear EINT
     if (ADE7758_INT_IF && ADE7758_INT_IE)
     {
        ADE7758_INT_IF = 0; 		// clear intterrupt flag
        ADE7758_INT_IE = 0;         // disable external interrupt
    	areg_temp = (Get_Two_Reg(0x01)); // read and clear watt regs
		breg_temp = (Get_Two_Reg(0x02)); // this insures that watt reg won'y overflow
		creg_temp = (Get_Two_Reg(0x03));
        get_three = Get_Three_Reg(0x1a); // allow interrupt at power chip
       // if interrupt line is low, then we may have missed a falling edge
       // while the interrupt was disabled.
       
        ADE7758_INT_IE = 1;
	 }
 }



















	


























